/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package kwtest;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsc.datastructures.GroupedData;
import jsc.independentsamples.KruskalWallisTest;

/**
 *
 * @author Mehmet G.
 */
public class KWTest {

    public static void randomSample(ArrayList<Double> values1,
            ArrayList<Double> values2,
            ArrayList<Double> values3, int size, int prefix, float toleranz) {

        ArrayList<Double> rnd1 = values1;
        ArrayList<Double> rnd2 = values2;
        ArrayList<Double> rnd3 = values3;
        int sum = values1.size() + values2.size() + values3.size();
        double[] data = new double[sum];
        String[] label = new String[sum];
        int k = 0;
        for (int i = 0; i < rnd1.size(); i++) {
            data[k] = rnd1.get(i);
            label[k] = "d1";
            k++;
        }
        for (int i = 0; i < rnd2.size(); i++) {
            data[k] = rnd2.get(i);
            label[k] = "d2";
            k++;
        }
        for (int i = 0; i < rnd3.size(); i++) {
            data[k] = rnd3.get(i);
            label[k] = "d3";
            k++;
        }
        GroupedData gd = new GroupedData(data, label);
        double[] data1 = gd.getData();
        KruskalWallisTest kwt = new KruskalWallisTest(gd, toleranz, true); //0.263
        System.out.println("*********** KwTest between all inputFiles *****************");
        System.out.println("pValue:" + kwt.getSP());
        System.out.println("*********** Pair-wise KwTest Between input files ***********");     

    }

    public static void randomSample2(ArrayList<Double> values1,
            ArrayList<Double> values2,
            int size, int prefix, String pair, float toleranz) {

        ArrayList<Double> rnd1 = values1;
        ArrayList<Double> rnd2 =values2;

        int sum = values1.size() + values2.size();
        double[] data = new double[sum];
        String[] label = new String[sum];
        int k = 0;
        for (int i = 0; i < rnd1.size(); i++) {
            data[k] = rnd1.get(i);
            label[k] = "d1";
            k++;
        }
        for (int i = 0; i < rnd2.size(); i++) {
            data[k] = rnd2.get(i);
            label[k] = "d2";
            k++;
        }

        GroupedData gd = new GroupedData(data, label);
        double[] data1 = gd.getData();
        KruskalWallisTest kwt = new KruskalWallisTest(gd, toleranz, true);
        System.out.println(" pValue between " +pair+": " +  kwt.getSP());
    
    }

    public static void writer(ArrayList<Double> values, String name) {
        try {
            FileWriter writer = new FileWriter(name);
            for (int i = 0; i < values.size(); i++) {
                writer.write(values.get(i).toString());
                writer.write("\n");
            }
            writer.close();
        } catch (IOException ex) {
            Logger.getLogger(KWTest.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
}
